package middleware

import (
	"net/http/httptest"
	"testing"

	"github.com/stretchr/testify/require"

	"code.justin.tv/devrel/devsite-rbac/internal/middleware/middlewarefakes"
)

func TestS2S(t *testing.T) {
	t.Run("/health should not use s2s middleware", func(t *testing.T) {
		fakeCallee := &middlewarefakes.FakeClientAPI{}
		middleware := S2S(fakeCallee)

		fakeHandler := &middlewarefakes.FakeHandler{}
		handler := middleware(fakeHandler)

		w := httptest.NewRecorder()
		r := httptest.NewRequest("GET", "/health", nil)
		handler.ServeHTTP(w, r)

		require.Equal(t, 1, fakeHandler.ServeHTTPCallCount())
		require.Equal(t, 0, fakeCallee.CapabilitiesInjectorMiddlewareCallCount())
	})

	t.Run("/path should use s2s middleware", func(t *testing.T) {
		middlewareHandler := &middlewarefakes.FakeHandler{}
		fakeCallee := &middlewarefakes.FakeClientAPI{}
		fakeCallee.CapabilitiesInjectorMiddlewareReturns(middlewareHandler)
		middleware := S2S(fakeCallee)

		fakeHandler := &middlewarefakes.FakeHandler{}
		handler := middleware(fakeHandler)

		w := httptest.NewRecorder()
		r := httptest.NewRequest("GET", "/path", nil)
		handler.ServeHTTP(w, r)

		require.Equal(t, 1, middlewareHandler.ServeHTTPCallCount())
		require.Equal(t, 1, fakeCallee.CapabilitiesInjectorMiddlewareCallCount())
	})

	t.Run("requests with auth header should not use s2s middleware", func(t *testing.T) {
		fakeCallee := &middlewarefakes.FakeClientAPI{}
		middleware := S2S(fakeCallee)

		fakeHandler := &middlewarefakes.FakeHandler{}
		handler := middleware(fakeHandler)

		w := httptest.NewRecorder()
		r := httptest.NewRequest("GET", "/path", nil)
		r.Header.Add(authorizationHeader, "auth-header")
		handler.ServeHTTP(w, r)

		require.Equal(t, 1, fakeHandler.ServeHTTPCallCount())
		require.Equal(t, 0, fakeCallee.CapabilitiesInjectorMiddlewareCallCount())
	})
}
