package utils_test

import (
	"fmt"
	"testing"

	"code.justin.tv/devrel/devsite-rbac/internal/utils"
	"github.com/stretchr/testify/require"
)

const retryTimes = 2

var testFunctionExecutionCount = 0

func testFunction() error {
	testFunctionExecutionCount = testFunctionExecutionCount + 1
	if testFunctionExecutionCount < retryTimes+1 {
		return fmt.Errorf("error")
	}
	return nil
}

func TestIfRetryWillWork(t *testing.T) {
	err := utils.WithRetry(testFunction, retryTimes)
	require.Equal(t, retryTimes+1, testFunctionExecutionCount)
	require.NoError(t, err)
}
