package utils_test

import (
	"fmt"
	"testing"

	"code.justin.tv/devrel/devsite-rbac/internal/utils"
	"github.com/stretchr/testify/require"
)

func TestIfThen(t *testing.T) {
	require.Equal(t, nil, utils.IfThen(false, true))
	require.True(t, utils.IfThen(true, true).(bool))
	require.Equal(t, nil, utils.IfThen(1 == 2, 1))
	require.Equal(t, 1, utils.IfThen(1 < 2, 1))
}

func TestIfThenElse(t *testing.T) {
	require.True(t, utils.IfThenElse(true, true, false).(bool))
	require.False(t, utils.IfThenElse(false, true, false).(bool))
	require.Equal(t, 3, utils.IfThenElse(1 == 2, 1, 3))
	require.Equal(t, 1, utils.IfThenElse(1 < 2, 1, 3))
}

func TestIfSliceLength(t *testing.T) {
	testArray := []string{"test", "array", "stuff"}
	require.Equal(t, testArray[0], utils.IfSliceLength(testArray, 0))
	require.Equal(t, testArray[1], utils.IfSliceLength(testArray, 1))
	require.Equal(t, testArray[2], utils.IfSliceLength(testArray, 2))
	require.Equal(t, nil, utils.IfSliceLength(testArray, 3))
}

func TestIfStringSliceLength(t *testing.T) {
	testArray := []string{"test", "array", "stuff"}
	require.Equal(t, testArray[0], utils.IfStringSliceLength(testArray, 0))
	require.Equal(t, testArray[1], utils.IfStringSliceLength(testArray, 1))
	require.Equal(t, testArray[2], utils.IfStringSliceLength(testArray, 2))
	require.Equal(t, "", utils.IfStringSliceLength(testArray, 3))
}

func TestParseUnknownToString(t *testing.T) {
	v, err := utils.ParseUnknownToString(1)
	require.NoError(t, err)
	require.Equal(t, "1", v)

	v, err = utils.ParseUnknownToString(1.12345)
	require.NoError(t, err)
	require.Equal(t, "1.12345", v)

	v, err = utils.ParseUnknownToString(1.000000)
	require.NoError(t, err)
	require.Equal(t, "1", v)

	v, err = utils.ParseUnknownToString("test")
	require.NoError(t, err)
	require.Equal(t, "test", v)

	v, err = utils.ParseUnknownToString(true)
	require.EqualError(t, err, fmt.Sprintf("Unsupported Type to string (%T)", true))
	require.Equal(t, "", v)
}
