-- Update first Administrator in company to Owner
-- To rollback set all Owners to Administrators

WITH groups AS (
	SELECT
		r."role", r.company_id, r.user_id, d.twitch_id, d.created_at,
		ROW_NUMBER() OVER (
			PARTITION BY r.company_id
			ORDER BY d.created_at
		) AS row
	FROM company_user_roles as r
	JOIN twitch_developers as d on r.user_id = d.user_id
	WHERE role = 'Administrator'
)
UPDATE company_user_roles as r set
	role = 'Owner'
FROM groups
WHERE
	groups.company_id = r.company_id
	AND groups.user_id = r.user_id
	AND groups.row = 1
