drop table public.company_invites;
create table public.company_invites
(
    id                uuid default uuid_generate_v4() not null
        constraint company_invites_pk2
            primary key
        constraint company_invites_pk_2
            unique,
    constraint company_invites_pk
        unique (company_id, invitee_twitch_id),
    company_id        uuid                            not null
        constraint company_invites_companies_id_fk
            references public.companies
            on update cascade on delete cascade,
    invitee_twitch_id varchar(50)                     not null,
    inviter_twitch_id varchar(50)                     not null,
    role              varchar(64)                     not null,
    created_at        timestamp                       not null
);

alter table public.company_invites
    owner to rbac;

create index company_invites_company_id_invitee_twitch_id_index
    on public.company_invites (company_id, invitee_twitch_id);

create unique index company_invites_id_uindex
    on public.company_invites (id);

