package localcache

import (
	"time"

	cache "github.com/patrickmn/go-cache"
)

//go:generate counterfeiter . LocalCache
type LocalCache interface {
	Get(k string) (interface{}, bool)
	SetDefault(k string, x interface{})
}

type localCacheImpl struct {
	cacheInstance *cache.Cache
}

func (c *localCacheImpl) Get(k string) (interface{}, bool) {
	return c.cacheInstance.Get(k)
}

func (c *localCacheImpl) SetDefault(k string, x interface{}) {
	c.cacheInstance.SetDefault(k, x)
}

var cacheInstance *localCacheImpl

func InitLocalCache(expirationTime, clearUpInterval time.Duration) LocalCache {
	if cacheInstance == nil {
		cacheInstance = &localCacheImpl{
			cacheInstance: cache.New(expirationTime, clearUpInterval),
		}
	}
	return cacheInstance
}
