package extensionreviewsserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/auth"
	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) GetExtension(ctx context.Context, params *rbacrpc.ExtensionVersionID) (*rbacrpc.Extension, error) {
	oauthToken := auth.GetRawAuthorizationToken(ctx)
	capabilities := "extensions::view_all_extensions"
	authFnParams := map[string]string{"extension_id": params.Id}
	cartmanToken, err := s.Cartman.GetToken(ctx, oauthToken, capabilities, authFnParams)
	if err != nil {
		return nil, errorutil.TwirpErrorFrom(err)
	}

	extv, err := s.Extensions.GetExtensionVersion(ctx, params.Id, params.Version, cartmanToken)
	if err != nil {
		return nil, errorutil.TwirpErrorFrom(err)
	}

	transitionLogs, err := s.DBExtensionReviewLogs.ListByExtensionID(ctx, extv.ID)
	if err != nil {
		return nil, err
	}

	return &rbacrpc.Extension{
		Id:          extv.ID,
		Version:     extv.Version,
		Name:        extv.Name,
		Description: extv.Description,
		Summary:     extv.Summary,
		State:       extv.State,
		AuthorName:  extv.AuthorName,

		TransitionLogs: transitionLogs,
	}, nil
}
