package extensionreviewsserver

import (
	"testing"

	"github.com/stretchr/testify/require"
	"github.com/twitchtv/twirp"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/devrel/devsite-rbac/rpc/testutil"
	"code.justin.tv/foundation/twitchclient"
)

func TestGetExtensionDocument_Success(t *testing.T) {
	server, _ := NewTestServer()

	extension, err := server.GetExtension(ctx, &rbacrpc.ExtensionVersionID{
		Id:      "abc",
		Version: "0.0.1",
	})
	require.NoError(t, err)
	require.NotNil(t, extension)
}

func TestGetExtensionDocument_NotFound(t *testing.T) {
	server, extensionsClient := NewTestServer()
	extensionsClient.GetExtensionReturnsError = &twitchclient.Error{StatusCode: 404}

	_, err := server.GetExtension(ctx, &rbacrpc.ExtensionVersionID{
		Id:      "abc",
		Version: "0.0.1",
	})
	testutil.EqualErrorCode(t, twirp.NotFound, err)
}
