package extensionreviewsserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) GetLatestAuthorNotes(ctx context.Context, params *rbacrpc.GetLatestAuthorNotesRequest) (*rbacrpc.GetLatestAuthorNotesResponse, error) {
	reviewLog, err := s.DBExtensionReviewLogs.GetLastWithAuthorNotes(ctx, params.AuthorTwitchId, params.ExtensionId)
	if err != nil {
		return nil, err
	}
	if reviewLog == nil {
		return nil, twirp.NotFoundError("Extension state was never set in review or there are no author notes.")
	}

	return &rbacrpc.GetLatestAuthorNotesResponse{
		AuthorTwitchId:     reviewLog.AuthorTwitchId,
		ExtensionId:        reviewLog.ExtensionId,
		ExtensionVersion:   reviewLog.ExtensionVersion,
		ReviewLogCreatedAt: reviewLog.CreatedAt,
		AuthorNotes:        reviewLog.AuthorNotes,
		AuthorChannel:      reviewLog.AuthorChannel,
	}, nil
}
