package extensionreviewsserver

import (
	"context"
	"database/sql"

	"code.justin.tv/devrel/devsite-rbac/backend/extensionreviewlogs/extensionreviewlogsfakes"
	"code.justin.tv/devrel/devsite-rbac/clients/cartman"
	"code.justin.tv/devrel/devsite-rbac/clients/extensions"
	"code.justin.tv/devrel/devsite-rbac/clients/salesforce"
	"code.justin.tv/devrel/devsite-rbac/clients/users"
	"code.justin.tv/devrel/devsite-rbac/internal/auth"
)

var (
	ctx                 = context.Background() // commonly used in tests
	ctxWithCartmanToken = auth.WithCartmanToken(ctx, "fake-cartman-token")
	ctxWithTwitchID     = auth.WithTwitchID(auth.WithRawAuthorizationToken(ctx, "Oauth fake-token"), "322")
)

// NewTestServer builds a server with mocks and noop-fakes.
func NewTestServer() (*Server, *extensions.FakeClient) {
	dbReviewLogs := extensionreviewlogsfakes.FakeExtensionReviewLogs{}
	dbReviewLogs.GetLastInReviewReturns(nil, sql.ErrNoRows) // not found by default

	fakeExtensions := extensions.FakeClient{}
	server := &Server{
		Salesforce:            &salesforce.NoopClient{},
		Extensions:            &fakeExtensions,
		Cartman:               &cartman.NoopClient{},
		Users:                 &users.NoopClient{},
		DBExtensionReviewLogs: &dbReviewLogs,
	}
	return server, &fakeExtensions
}
