package privacyserver

import (
	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories/actionhistoriesfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/backendfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/developerapplications/developerapplicationsfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/memberships/membershipsfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/viennauserwhitelist/viennauserwhitelistfakes"
)

type TestPrivacyServer struct {
	Server                    *Server
	MockBackender             *backendfakes.FakeBackender
	MockActionHistories       *actionhistoriesfakes.FakeActionHistories
	MockMemberships           *membershipsfakes.FakeMemberships
	MockDeveloperApplications *developerapplicationsfakes.FakeDeveloperApplications
	MockViennaUserWhitelist   *viennauserwhitelistfakes.FakeUserWhitelist
}

// NewTestServer builds a server with mocks and noop-fakes.
func NewTestPrivacyServer() *TestPrivacyServer {
	mockBackender := &backendfakes.FakeBackender{}
	mockActionHistories := &actionhistoriesfakes.FakeActionHistories{}
	mockMemberships := &membershipsfakes.FakeMemberships{}
	mockDeveloperApplications := &developerapplicationsfakes.FakeDeveloperApplications{}
	mockViennaUserWhitelist := &viennauserwhitelistfakes.FakeUserWhitelist{}

	server := &Server{
		Backend:               mockBackender,
		ActionHistories:       mockActionHistories,
		Memberships:           mockMemberships,
		DeveloperApplications: mockDeveloperApplications,
		ViennaUserWhitelist:   mockViennaUserWhitelist,
	}

	return &TestPrivacyServer{
		Server:                    server,
		MockBackender:             mockBackender,
		MockActionHistories:       mockActionHistories,
		MockMemberships:           mockMemberships,
		MockDeveloperApplications: mockDeveloperApplications,
		MockViennaUserWhitelist:   mockViennaUserWhitelist,
	}
}
