package rbacactionhistoryserver

import (
	"fmt"

	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/devrel/devsite-rbac/rpc/server"
	"github.com/twitchtv/twirp"
	"goji.io/pat"
)

type Server struct {
	ActionHistories actionhistories.ActionHistories
}

func New(srv *Server, hooks *twirp.ServerHooks) *server.Route {
	handler := rbacrpc.NewRBACActionHistoryServer(srv, hooks)
	return &server.Route{
		Pattern: pat.Post(fmt.Sprintf("%s*", rbacrpc.RBACActionHistoryPathPrefix)),
		Handler: handler,
	}
}
