package rbacadminserver

import (
	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories/actionhistoriesfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/backendfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/featuregating/featuregatingfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/memberships/membershipsfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/viennauserwhitelist/viennauserwhitelistfakes"
	channelsfakes "code.justin.tv/devrel/devsite-rbac/clients/channels_client/channels_clientfakes"
	"code.justin.tv/devrel/devsite-rbac/clients/clue/cluefakes"
	"code.justin.tv/devrel/devsite-rbac/clients/nioh/niohfakes"
	"code.justin.tv/devrel/devsite-rbac/clients/passport/passportfakes"
	"code.justin.tv/devrel/devsite-rbac/clients/users/usersfakes"
)

type TestAdminServer struct {
	Server                  *Server
	MockBackender           *backendfakes.FakeBackender
	MockActionHistories     *actionhistoriesfakes.FakeActionHistories
	MockViennaUserWhitelist *viennauserwhitelistfakes.FakeUserWhitelist
	MockFeatureGating       *featuregatingfakes.FakeFeatureGating
	MockMemberships         *membershipsfakes.FakeMemberships
	MockUsers               *usersfakes.FakeUsers
	MockChannels            *channelsfakes.FakeChannels
	MockNioh                *niohfakes.FakeNioh
	MockClue                *cluefakes.FakeClue
	MockPassport            *passportfakes.FakeClient
}

func NewTestAdminServer() *TestAdminServer {
	mockBackender := &backendfakes.FakeBackender{}
	mockActionHistories := &actionhistoriesfakes.FakeActionHistories{}
	mockViennaUserWhitelist := &viennauserwhitelistfakes.FakeUserWhitelist{}
	mockFeatureGating := &featuregatingfakes.FakeFeatureGating{}
	mockMemberships := &membershipsfakes.FakeMemberships{}
	mockUsers := &usersfakes.FakeUsers{}
	mockChannels := &channelsfakes.FakeChannels{}
	mockNioh := &niohfakes.FakeNioh{}
	mockClue := &cluefakes.FakeClue{}
	mockPassport := &passportfakes.FakeClient{}

	server := &Server{
		Backend:             mockBackender,
		ActionHistories:     mockActionHistories,
		ViennaUserWhitelist: mockViennaUserWhitelist,
		FeatureGating:       mockFeatureGating,
		Memberships:         mockMemberships,
		Users:               mockUsers,
		Channels:            mockChannels,
		Nioh:                mockNioh,
		Clue:                mockClue,
		Passport:            mockPassport,
	}

	return &TestAdminServer{
		Server:                  server,
		MockBackender:           mockBackender,
		MockActionHistories:     mockActionHistories,
		MockViennaUserWhitelist: mockViennaUserWhitelist,
		MockFeatureGating:       mockFeatureGating,
		MockMemberships:         mockMemberships,
		MockUsers:               mockUsers,
		MockChannels:            mockChannels,
		MockNioh:                mockNioh,
		MockClue:                mockClue,
		MockPassport:            mockPassport,
	}
}
