package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) CreateCompanyApplication(ctx context.Context, params *rbacrpc.CreateCompanyApplicationRequest) (*rbacrpc.CompanyApplication, error) {
	if err := validateCreateCompanyApplicationParams(params); err != nil {
		return nil, err
	}

	// Check if a company with this name already exists
	company, err := s.Backend.SelectCompanyByCompanyName(ctx, params.CompanyName)
	if err != nil && !errorutil.IsErrNoRows(err) {
		return nil, err
	}
	if company != nil && err == nil { // company already exists
		return &rbacrpc.CompanyApplication{}, twirp.NewError(twirp.AlreadyExists, "cannot create application this company already exists")
	}

	// Create Company application
	companyApp, insertErr := s.Backend.InsertCompanyApplication(ctx, params)
	if insertErr != nil {
		return nil, insertErr
	}

	return &rbacrpc.CompanyApplication{Id: companyApp.Id}, nil
}

func validateCreateCompanyApplicationParams(params *rbacrpc.CreateCompanyApplicationRequest) error {
	return errorutil.ValidateRequiredArgs(errorutil.Args{
		{"company name", params.CompanyName},
		{"website", params.CompanyWebsite},
		{"company type", params.CompanyType},
		{"country", params.Country},
		{"contact first name", params.ContactFirstName},
		{"contact last name", params.ContactLastName},
		{"twitch id", params.TwitchId},
	})
}
