package rbacrpcserver

import (
	"context"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories"
	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/internal/auth"
)

const dartTrace string = "DartEmailTrace"

func (s *Server) auditEmailAction(ctx context.Context, a DartEmailAction) {
	if a.UserTwitchID == "" {
		a.UserTwitchID = auth.GetTwitchID(ctx)
	}

	actionHistory := &actionhistories.ActionHistory{
		UserTwitchID: a.UserTwitchID,
		Action:       a.ActionFormat,
		EntityType:   dartTrace,
		EntityID:     a.EntityTwitchID,
		CompanyID:    common.NewSQLNullString(a.CompanyID),
	}

	s.ActionHistories.InsertActionHistory(ctx, actionHistory)
	logx.Info(ctx, actionHistory.ToLogxFields())

}

type DartEmailAction struct {
	UserTwitchID   string // twitchID of the main actor of the update
	EntityTwitchID string // twitchID of the membership that is being updated
	ActionFormat   string
	CompanyID      string
}
