package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) DeleteDeveloperApplication(ctx context.Context, params *rbacrpc.DeleteDeveloperApplicationRequest) (*rbacrpc.Empty, error) {
	if params.Id == "" {
		return nil, twirp.RequiredArgumentError("id")
	}

	err := s.DevApps.DeleteDeveloperApplication(ctx, params.Id)
	if errorutil.IsErrNoRows(err) {
		return nil, twirp.NotFoundError("application not found")
	}
	if err != nil {
		return nil, err
	}

	return &rbacrpc.Empty{}, nil
}
