package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) IsFeatureEnabled(ctx context.Context, params *rbacrpc.IsFeatureEnabledRequest) (*rbacrpc.FeatureEnabledResponse, error) {
	enabled, err := s.FeatureGating.BoolFeatureGate(ctx, params.FeatureGatingKey)
	if err != nil {
		return nil, err
	}
	return &rbacrpc.FeatureEnabledResponse{
		Enabled: enabled,
	}, nil
}

func (s *Server) IsValueEnabled(ctx context.Context, params *rbacrpc.IsValueEnabledRequest) (*rbacrpc.FeatureEnabledResponse, error) {
	result, err := s.FeatureGating.StringsFeatureGate(ctx, params.FeatureGatingKey)
	if err != nil {
		return nil, err
	}
	var isValueEnabled bool
	for _, str := range result {
		if str == params.ValueInString {
			isValueEnabled = true
			break
		}
	}
	return &rbacrpc.FeatureEnabledResponse{
		Enabled: isValueEnabled,
	}, nil
}
