package rbacrpcserver

import (
	"context"

	"github.com/twitchtv/twirp"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) GetCompanyApplication(ctx context.Context, id *rbacrpc.Id) (*rbacrpc.CompanyApplication, error) {
	capp, err := s.Backend.GetCompanyApplication(ctx, id.Id)
	if errorutil.IsErrNoRows(err) {
		return nil, twirp.NotFoundError("not_found")
	}
	if err != nil {
		return nil, err
	}
	cappRPC := capp.ToRPC()

	// Add EmailVerificationStatus value from EVS (Email Verification Service), we don't store that in our database.
	cappRPC.EmailVerificationStatus = s.EVS.GetVerificationStatus(ctx, capp.Id, capp.ContactEmail)

	// Add game names from ids using the Discovery service
	s.addGameNamesToCompanyApplications(ctx, &rbacrpc.ListCompanyApplicationsResponse{
		CompanyApplications: []*rbacrpc.CompanyApplication{
			cappRPC,
		},
	})
	return cappRPC, nil
}
