package rbacrpcserver

import (
	"context"

	"github.com/twitchtv/twirp"

	"code.justin.tv/devrel/devsite-rbac/backend/memberships"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) GetCompanyByTwitchID(ctx context.Context, id *rbacrpc.Id) (*rbacrpc.Company, error) {
	membs, _, err := s.Memberships.ListMemberships(ctx, memberships.ListMembershipsParams{
		TwitchID:   id.Id,
		Limit:      1,
		OrderBy:    "CREATED_AT",
		OrderByDir: "ASC",
	})
	if err != nil {
		return nil, err
	}
	if len(membs) == 0 {
		return nil, twirp.NotFoundError("not_found")
	}
	memb := membs[0] // pick the first one only, multi-org is not supported on this endpoint

	company, err := s.Backend.SelectCompany(ctx, memb.CompanyID)
	if err != nil {
		return nil, err
	}
	return company, nil
}
