package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) GetCompanyInvitesByCompanyID(ctx context.Context, params *rbacrpc.GetCompanyInvitesByCompanyIDRequest) (*rbacrpc.GetCompanyInvitesByCompanyIDResponse, error) {
	if params.Limit == 0 {
		params.Limit = 10
	}
	invites, total, err := s.Backend.SelectComanyInvitesByCompanyId(ctx, params.CompanyId, params.Limit, params.Offset)
	if err != nil {
		return nil, err
	}
	if len(invites) == 0 {
		return &rbacrpc.GetCompanyInvitesByCompanyIDResponse{}, nil
	}

	return &rbacrpc.GetCompanyInvitesByCompanyIDResponse{
		CompanyInvites: invites,
		XTotal:         total,
	}, nil
}
