package rbacrpcserver

import (
	"testing"

	"code.justin.tv/devrel/devsite-rbac/backend/common"
	"code.justin.tv/devrel/devsite-rbac/backend/developerapplications"
	"code.justin.tv/devrel/devsite-rbac/backend/developerapplications/developerapplicationsfakes"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/stretchr/testify/require"
)

func TestGetDeveloperApplications_Success(t *testing.T) {
	server, _ := NewTestServer()

	fakeDevApp := NewFakeDeveloperApplication()
	fakeDevApps := &developerapplicationsfakes.FakeDeveloperApplications{}
	fakeDevApps.ListDeveloperApplicationsReturns([]developerapplications.DeveloperApplication{
		fakeDevApp,
	}, nil)
	server.DevApps = fakeDevApps

	resp, err := server.GetDeveloperApplications(ctxBck, &rbacrpc.GetDeveloperApplicationsRequest{
		CompanyId: fakeDevApp.CompanyID,
		Limit:     1,
	})
	require.NoError(t, err)
	require.NotNil(t, resp)
	require.Len(t, resp.DeveloperApplications, 1)
	require.Equal(t, int32(1), resp.XTotal)
	require.Equal(t, fakeDevApp.ID, resp.DeveloperApplications[0].Id)
	require.Equal(t, fakeDevApp.CompanyID, resp.DeveloperApplications[0].CompanyId)
	require.Equal(t, fakeDevApp.FirstName, resp.DeveloperApplications[0].FirstName)
	require.Equal(t, fakeDevApp.LastName, resp.DeveloperApplications[0].LastName)
	require.Equal(t, fakeDevApp.Email, resp.DeveloperApplications[0].Email)
}

//
// Helpers
//

func NewFakeDeveloperApplication() developerapplications.DeveloperApplication {
	uuid := common.NewUUID()
	return developerapplications.DeveloperApplication{
		ID:        uuid,
		CompanyID: common.NewUUID(),
		TwitchID:  "TwitchID-" + uuid,
		FirstName: "FirstName-" + uuid,
		LastName:  "McKenzy",
		Title:     "foyo",
		Email:     "Email.foyo",
		CreatedAt: common.TimeNowStr(),
	}
}
