package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) GetGameApplicationsByCompany(ctx context.Context, id *rbacrpc.Id) (*rbacrpc.GetGameApplicationsByCompanyResponse, error) {
	_, err := s.Backend.SelectCompany(ctx, id.GetId())
	if errorutil.IsErrNoRows(err) {
		return nil, twirp.NotFoundError("company not found")
	}
	if err != nil {
		return nil, err
	}

	res, err := s.Backend.FindGameApplicationsByCompany(ctx, id.GetId())
	if err != nil {
		return nil, err
	}

	s.addGameNameToGameApplications(ctx, res.GameApplications)

	return res, nil
}
