package rbacrpcserver

import (
	"strconv"

	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) GetGamesByCompany(ctx context.Context, id *rbacrpc.Id) (*rbacrpc.GetGamesByCompanyResponse, error) {
	company, err := s.Backend.SelectCompany(ctx, id.GetId())
	if errorutil.IsErrNoRows(err) {
		return nil, twirp.NotFoundError("company not found")
	}
	if err != nil {
		return nil, err
	}

	// for now use a hard limit, we didn't define the max number of games per company yet
	var gamesLimit uint64 = 200
	gameResources, total, err := s.Backend.FindResources(ctx, id.Id, "game", "", gamesLimit, 0)
	if err != nil {
		return nil, err
	}

	externalIDsAsStrings := make([]string, len(gameResources))
	for i, gameResource := range gameResources {
		externalIDsAsStrings[i] = gameResource.ExternalId
	}

	gamesResp, err := s.Discovery.GetAll(ctx, externalIDsAsStrings)
	if err != nil {
		return nil, err
	}

	games := []*rbacrpc.Game{}
	for gameID, gameData := range gamesResp {
		id, err := strconv.ParseInt(gameID, 10, 32)
		if err != nil {
			return nil, err
		}

		games = append(games, &rbacrpc.Game{
			Id:          int32(id),
			GiantbombId: int32(gameData.Game.GiantbombID),
			Name:        gameData.Game.Name,
		})
	}

	return &rbacrpc.GetGamesByCompanyResponse{XTotal: int32(total), Company: company, Games: games}, nil
}
