package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) GetGamesByTwitchID(ctx context.Context, id *rbacrpc.Id) (*rbacrpc.GetGamesByTwitchIDResponse, error) {
	companies, err := s.ListCompanyMemberships(ctx, &rbacrpc.ListCompanyMembershipsRequest{TwitchId: id.Id})
	if err != nil {
		return nil, err
	}

	var total int32 = 0
	var games []*rbacrpc.Game

	for _, c := range companies.Memberships {
		resp, err := s.GetGamesByCompany(ctx, &rbacrpc.Id{
			Id: c.Company.Id,
		})
		if err != nil {
			return nil, err
		}
		total = total + resp.XTotal
		games = append(games, resp.Games...)
	}
	return &rbacrpc.GetGamesByTwitchIDResponse{XTotal: total, Games: games}, nil
}
