package rbacrpcserver

import (
	"context"
	"strconv"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) ListCompanies(ctx context.Context, params *rbacrpc.ListCompaniesRequest) (*rbacrpc.ListCompaniesResponse, error) {
	if params.Limit == 0 {
		params.Limit = 10 // default page size
	}

	// load companies by game
	gameID := params.GetOwnsGameId()
	if gameID > 0 {
		companies, err := s.Backend.FindCompaniesWithResource(ctx, strconv.Itoa(int(gameID)), "game")
		if err != nil {
			return nil, err
		}

		return &rbacrpc.ListCompaniesResponse{Companies: companies, XTotal: int32(len(companies))}, nil
	}

	res, err := s.Backend.FindCompanies(ctx, params)
	if err != nil {
		return nil, err
	}

	return res, nil
}
