package rbacrpcserver

import (
	"context"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/devrel/devsite-rbac/backend/companyapplications"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) ListCompanyApplications(ctx context.Context, params *rbacrpc.ListCompanyApplicationsRequest) (*rbacrpc.ListCompanyApplicationsResponse, error) {
	list, total, err := s.Backend.ListCompanyApplications(ctx, params)
	if err != nil {
		return nil, err
	}

	// Note: if the application has games, their names are not included in the list response.
	// We could add them with s.addGameNamesToCompanyApplications(ctx, res) but those names are never used in lists.

	return &rbacrpc.ListCompanyApplicationsResponse{
		CompanyApplications: companyapplications.ListToRPC(list),
		XTotal:              total,
	}, nil
}

func (s *Server) addGameNamesToCompanyApplications(ctx context.Context, res *rbacrpc.ListCompanyApplicationsResponse) {
	gamesByID := make(map[string]bool)

	for _, companyApp := range res.GetCompanyApplications() {
		for _, game := range companyApp.Games {
			gamesByID[game.Id] = true
		}
	}

	var gameIDs []string
	for id := range gamesByID {
		gameIDs = append(gameIDs, id)
	}
	if len(gameIDs) == 0 {
		return
	}

	dgamesByIDs, err := s.Discovery.GetAll(ctx, gameIDs)
	if err != nil {
		// Return a response a log the error. Game names are best effort
		logx.Error(ctx, err)
		return
	}

	for _, companyApp := range res.GetCompanyApplications() {
		for _, game := range companyApp.Games {
			dgame, ok := dgamesByIDs[game.Id]
			if !ok || dgame == nil {
				continue
			}

			game.Name = dgame.Name
		}
	}
}
