package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/memberships"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) ListCompanyMemberships(ctx context.Context, params *rbacrpc.ListCompanyMembershipsRequest) (*rbacrpc.ListCompanyMembershipsResponse, error) {
	// Load all memberships for this twitch ID
	membs, _, err := s.Memberships.ListMemberships(ctx, memberships.ListMembershipsParams{
		TwitchID: params.TwitchId,
		Limit:    100,
	})
	if err != nil {
		return nil, err
	}
	if len(membs) == 0 {
		return &rbacrpc.ListCompanyMembershipsResponse{}, nil
	}

	// Load companies from the memberships' company ids
	companyIDs := make([]string, len(membs))
	for i, memb := range membs {
		companyIDs[i] = memb.CompanyID
	}
	companiesByID, err := s.Backend.SelectCompanies(ctx, companyIDs)
	if err != nil {
		return nil, err
	}

	// Add data for company and permissions into each membership
	var memberships []*rbacrpc.CompanyMembership
	for _, memb := range membs {
		company, ok := companiesByID[memb.CompanyID]
		if !ok {
			continue
		}

		membership := &rbacrpc.CompanyMembership{
			Company:  company,
			Role:     memb.Role,
			JoinedAt: memb.CreatedAt,

			SelfCanLeave:        memb.Role != billingManagerRole && memb.Role != ownerRole,
			SelfCanAddMember:    doesRoleHavePermission(memb.Role, "addUser"),
			SelfCanRemoveMember: doesRoleHavePermission(memb.Role, "removeUser"),
		}
		memberships = append(memberships, membership)
	}

	return &rbacrpc.ListCompanyMembershipsResponse{Memberships: memberships}, nil
}
