package rbacrpcserver

import (
	"fmt"

	"code.justin.tv/devrel/devsite-rbac/backend/companyinvites"
	"code.justin.tv/devrel/devsite-rbac/backend/featuregating"
	"code.justin.tv/devrel/devsite-rbac/backend/viennauserwhitelist"

	"code.justin.tv/devrel/devsite-rbac/clients/cartman"
	"code.justin.tv/devrel/devsite-rbac/clients/clue"
	"code.justin.tv/devrel/devsite-rbac/clients/dart"
	"code.justin.tv/devrel/devsite-rbac/clients/owlcli"

	"code.justin.tv/devrel/devsite-rbac/clients/passport"

	"code.justin.tv/devrel/devsite-rbac/clients/moneypenny"

	"goji.io/pat"

	"code.justin.tv/devrel/devsite-rbac/backend"
	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories"
	"code.justin.tv/devrel/devsite-rbac/backend/developerapplications"
	"code.justin.tv/devrel/devsite-rbac/backend/memberships"
	"code.justin.tv/devrel/devsite-rbac/clients/discovery"
	"code.justin.tv/devrel/devsite-rbac/clients/evs"
	"code.justin.tv/devrel/devsite-rbac/clients/pushy"
	"code.justin.tv/devrel/devsite-rbac/clients/salesforce"
	"code.justin.tv/devrel/devsite-rbac/clients/users"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/devrel/devsite-rbac/rpc/server"

	"github.com/twitchtv/twirp"
)

type Server struct {
	DropsJWTKey string

	// DB
	ActionHistories     actionhistories.ActionHistories
	Backend             backend.Backender
	DevApps             developerapplications.DeveloperApplications
	FeatureGating       featuregating.FeatureGating
	Memberships         memberships.Memberships
	CompanyInvites      companyinvites.CompanyInvites
	ViennaUserWhitelist viennauserwhitelist.UserWhitelist

	// Clients
	Cartman    cartman.Client
	Discovery  discovery.Discovery
	Emailer    pushy.Emailer
	EVS        evs.EVS
	Dart       dart.Dart
	Moneypenny moneypenny.Client
	Owl        owlcli.Client
	Passport   passport.Client
	Salesforce salesforce.Client
	Users      users.Users
	Clue       clue.Clue
}

func NewServer(srv *Server, hooks *twirp.ServerHooks) *server.Route {
	handler := rbacrpc.NewRBACServer(srv, hooks)
	return &server.Route{
		Pattern: pat.Post(fmt.Sprintf("%s*", rbacrpc.RBACPathPrefix)),
		Handler: handler,
	}
}
