package rbacrpcserver

import (
	"context"
	"errors"

	"code.justin.tv/devrel/devsite-rbac/clients/cartman"
	"code.justin.tv/devrel/devsite-rbac/clients/clue/cluefakes"
	"code.justin.tv/devrel/devsite-rbac/clients/users/usersfakes"

	"code.justin.tv/devrel/devsite-rbac/backend/actionhistories/actionhistoriesfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/backendfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/companyinvites/companyinvitesfakes"
	"code.justin.tv/devrel/devsite-rbac/backend/viennauserwhitelist/viennauserwhitelistfakes"

	"code.justin.tv/devrel/devsite-rbac/backend/developerapplications"
	"code.justin.tv/devrel/devsite-rbac/clients/discovery"
	"code.justin.tv/devrel/devsite-rbac/clients/pushy"
	"code.justin.tv/devrel/devsite-rbac/clients/salesforce"
)

var (
	errUnexpected = errors.New("unexpected error")
	ctxBck        = context.Background()
)

// NewTestServer builds a server with mocks and noop-fakes.
// If you want to explicitly mock another dependency, simply add it to the result, e.g.:
//     server, _ := NewTestServer()
//     mockDiscovery := &discoverytest.Discovery{}
//     server.Discovery = mockDiscovery;
//
func NewTestServer() (*Server, *backendfakes.FakeBackender) {
	backender := &backendfakes.FakeBackender{}

	server := &Server{
		Backend:             backender,
		Emailer:             &pushy.NoopClient{},
		Discovery:           &discovery.NoopClient{},
		Salesforce:          &salesforce.NoopClient{},
		ActionHistories:     &actionhistoriesfakes.FakeActionHistories{},
		CompanyInvites:      &companyinvitesfakes.FakeCompanyInvites{},
		DevApps:             &developerapplications.NoopClient{},
		Cartman:             &cartman.NoopClient{},
		ViennaUserWhitelist: &viennauserwhitelistfakes.FakeUserWhitelist{},
		Clue:                &cluefakes.FakeClue{},
		Users:               &usersfakes.FakeUsers{},
	}

	return server, backender
}
