package rbacrpcserver

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestSanitizeRole(t *testing.T) {
	for _, testCase := range []struct {
		role     string
		expected string
		valid    bool
	}{
		{
			role:     "developer",
			expected: "Developer",
			valid:    true,
		},
		{
			role:  "adsf",
			valid: false,
		}, {
			role:     "Administrator",
			expected: "Administrator",
			valid:    true,
		},
	} {
		t.Run(testCase.role, func(t *testing.T) {
			actual, err := SanitizeRole("role", testCase.role)
			if testCase.valid {
				require.NoError(t, err)
				require.Equal(t, testCase.expected, actual)
			} else {
				require.Error(t, err)
			}
		})
	}
}
