package rbacrpcserver

import (
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
	"context"
)

func (s *Server) SearchCompanies(ctx context.Context, params *rbacrpc.SearchCompaniesRequest) (*rbacrpc.SearchCompaniesResponse, error) {
	if params.Query == "" {
		return nil, twirp.RequiredArgumentError("query")
	}
	if params.Limit == 0 {
		params.Limit = 10 // default page size
	}

	return s.Backend.SearchCompanies(ctx, params.Query, params.Limit)
}
