package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/companyapplications"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) SearchCompanyApplications(ctx context.Context, params *rbacrpc.SearchCompanyApplicationsRequest) (*rbacrpc.SearchCompanyApplicationsResponse, error) {
	if params.Query == "" {
		return nil, twirp.RequiredArgumentError("query")
	}
	if params.Limit == 0 {
		params.Limit = 10 // default page size
	}

	list, total, err := s.Backend.SearchCompanyApplications(ctx, params.Query, params.Limit)
	if err != nil {
		return nil, err
	}
	rpcList := companyapplications.ListToRPC(list)

	// Add EmailVerificationStatus value from EVS (Email Verification Service), we don't store that in our database.
	for _, capp := range rpcList {
		capp.EmailVerificationStatus = s.EVS.GetVerificationStatus(ctx, capp.Id, capp.ContactEmail)
	}

	return &rbacrpc.SearchCompanyApplicationsResponse{
		CompanyApplications: rpcList,
		XTotal:              total,
	}, nil
}
