package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/auth"
	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) UpdateCompany(ctx context.Context, params *rbacrpc.UpdateCompanyRequest) (*rbacrpc.Company, error) {
	if err := errorutil.ValidateRequiredArgs(errorutil.Args{
		{"id", params.Id},
		{"company_name", params.CompanyName},
		{"identifier", params.Identifier},
	}); err != nil {
		return nil, err
	}
	if err := errorutil.ValidateUUID("id", params.Id); err != nil {
		return nil, err
	}

	// Ensure permissions: for now this endpoint can only be called from Vienna
	if !auth.IsWhitelistAdmin(ctx) {
		return nil, twirp.NewError(twirp.PermissionDenied, "cannot update company")
	}

	company, err := s.Backend.UpdateCompany(ctx, params)
	if errorutil.IsErrNoRows(err) {
		return nil, twirp.InvalidArgumentError("id", "does not identify an existing company")
	}
	if err != nil {
		return nil, err
	}

	return company, nil
}
