package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"github.com/twitchtv/twirp"
)

func (s *Server) UpdateCompanyApplication(ctx context.Context, params *rbacrpc.UpdateCompanyApplicationRequest) (*rbacrpc.CompanyApplication, error) {
	if err := s.validateUpdateCompanyApplication(ctx, params); err != nil {
		return nil, err
	}
	companyApplication, err := s.Backend.UpdateCompanyApplication(ctx, params)
	if err != nil {
		return nil, err
	}

	// Add EmailVerificationStatus value from EVS (Email Verification Service), we don't store that in our database.
	companyApplication.EmailVerificationStatus = s.EVS.GetVerificationStatus(ctx, companyApplication.Id, companyApplication.ContactEmail)

	s.addGameNamesToCompanyApplications(ctx, &rbacrpc.ListCompanyApplicationsResponse{
		CompanyApplications: []*rbacrpc.CompanyApplication{
			companyApplication,
		},
	})
	return companyApplication, nil
}

func (s *Server) validateUpdateCompanyApplication(ctx context.Context, params *rbacrpc.UpdateCompanyApplicationRequest) error {
	if params.CompanyName == "" {
		return twirp.RequiredArgumentError("company_name")
	}

	_, err := s.Backend.GetCompanyApplication(ctx, params.Id)
	if errorutil.IsErrNoRows(err) {
		return twirp.InvalidArgumentError("id", "company application not found")
	}
	return err
}
