package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/backend/memberships"
	clientutils "code.justin.tv/web/users-service/client"
	"github.com/twitchtv/twirp"
)

// Returns true if the user below the max allowed company memberships
func (s *Server) CheckWithinUserMembershipLimit(ctx context.Context, twitchId string) (bool, error) {
	valid := false

	// if memberships.MaxAllowedMemberships is 0 then the check for max membership is not needed
	if memberships.MaxAllowedMemberships == 0 {
		return false, nil
	}

	maxMemberships := memberships.MaxAllowedMemberships

	userProps, errUser := s.Users.GetUserByID(ctx, twitchId)
	if clientutils.IsUserNotFound(errUser) {
		return false, twirp.NewError(twirp.NotFound, "user does not exists")
	}
	if errUser != nil {
		return false, errUser
	}

	if userProps.Admin != nil && *userProps.Admin {
		maxMemberships = memberships.MaxStaffMemberships
	}

	_, totalMembership, err := s.Memberships.ListMemberships(ctx, memberships.ListMembershipsParams{
		TwitchID: twitchId,
		Limit:    uint64(maxMemberships),
	})
	if err != nil {
		return false, err
	}

	// verify the user is not at or above the max allow memberships
	if totalMembership < int32(maxMemberships) {
		valid = true
	}

	return valid, nil
}
