package rbacrpcserver

import (
	"context"

	"code.justin.tv/devrel/devsite-rbac/internal/errorutil"
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
)

func (s *Server) ValidateCompanyMembershipByTwitchID(ctx context.Context, params *rbacrpc.ValidateCompanyMembershipByTwitchIDRequest) (*rbacrpc.ValidateCompanyMembershipByTwitchIDResponse, error) {

	response := &rbacrpc.ValidateCompanyMembershipByTwitchIDResponse{}
	response.Valid = false

	if err := errorutil.ValidateRequiredArgs(errorutil.Args{
		{"company_id", params.CompanyId},
		{"user_id", params.UserId},
	}); err != nil {
		return nil, err
	}

	if err := errorutil.ValidateUUID("company_id", params.CompanyId); err != nil {
		return nil, err
	}

	memb, err := s.Memberships.GetMembership(ctx, params.CompanyId, params.UserId)
	if errorutil.IsErrNoRows(err) {
		return response, nil
	}
	if err != nil {
		return nil, err
	}

	if memb.CompanyID == params.CompanyId {
		response.Valid = true
	}

	return response, nil
}
