#!/bin/bash

COVERAGE_FILE=$1
MODE=$2

DIFF_COVERAGE_FILE=diff_${COVERAGE_FILE}
CHANGES_FILE=changes_${COVERAGE_FILE}

# get files that have changed since branching from master
git --no-pager diff --name-only `git merge-base origin/master HEAD` HEAD > ${CHANGES_FILE}

# copy mode from existing test file
head -n 1 $COVERAGE_FILE > ${DIFF_COVERAGE_FILE}

# filter changed files by those changed on this branch
cat ${COVERAGE_FILE} | grep -f ${CHANGES_FILE} >> ${DIFF_COVERAGE_FILE}

go tool cover -html=${DIFF_COVERAGE_FILE}

rm ${CHANGES_FILE}
