#!/usr/bin/env bash
set -e

ada credentials update --once --profile twitch-rbac-dev --account 059023621032 --role admin || (echo "===> ada failed: run mwinit <==" && exit 1)

USER_CREDS=$(aws secretsmanager get-secret-value --secret-id devsite/rbac/staging/db_rds --profile=twitch-rbac-dev --region=us-west-2 --query 'SecretString'  --output text )
CURRENT_INSTANCE=$(echo ${USER_CREDS} | sed -n 's|.*"dbInstanceIdentifier":"\([^"]*\)".*|\1|p')
CURRENT_HOST=$(echo ${USER_CREDS} | sed -n 's|.*"host":"\([^"]*\)".*|\1|p')
CURRENT_PASS=$(echo ${USER_CREDS} | sed -n 's|.*"password":"\([^"]*\)".*|\1|p')
INSTANCES=$(aws rds describe-db-clusters --profile=twitch-rbac-dev --region=us-west-2 --query 'DBClusters[*].DBClusterIdentifier' --output text)

echo
echo "Please choose which db instance will be the staging instance:"
count=0
for name in $INSTANCES;do
  count=$((count+1))
  current=''
  if [ $CURRENT_INSTANCE == $name ]
   then
   	current='(current)'
   else
   	current=''
  fi
  printf '\t%s) %s %s' $count $name $current
  echo
done
read -p "Choose a number from the list: " CHOICE
echo

NEW_INSTANCE=""
count=0
for name in $INSTANCES;do
  count=$((count+1))
  if [ $count -eq $CHOICE ]
   then
   	NEW_INSTANCE=$name
  fi
done

if [ $NEW_INSTANCE == "" ]
then
	echo "Invalid choice"
	exit 1
fi

if [ $NEW_INSTANCE == $CURRENT_INSTANCE ]
then
	echo 'You selected the current staging instance no updating needed'
	exit 1
fi

NEW_HOST=$(aws rds describe-db-clusters --profile=twitch-rbac-dev --region=us-west-2 --db-cluster-identifier=${NEW_INSTANCE} --query 'DBClusters[0].Endpoint' --output text)

if [ $NEW_INSTANCE == "None" ]
then
	echo "Host for selected intance could not be found."
	exit 1
fi

UPDATE_CREDS=$(echo ${USER_CREDS} | sed 's/'$CURRENT_HOST'/'$NEW_HOST'/')
UPDATE_CREDS=$(echo ${UPDATE_CREDS} | sed 's/'$CURRENT_INSTANCE'/'$NEW_INSTANCE'/')

#escape regex special charaters in password
PASS_ESC=$(sed 's/[\*\.&]/\\&/g' <<<"$CURRENT_PASS")
PREVIEW_CREDS=$(echo ${UPDATE_CREDS} | sed 's/'$PASS_ESC'/<REDACTED>/')

echo "Verify the 'host' and 'dbInstanceIdentifier' have udpated correctly"
echo ${PREVIEW_CREDS}
echo

read -p "Type 'yes' to contiune the swap and restart staging app servers: " ANS
if [ $ANS != 'yes' ]
then
	echo "Canceling staging db swap"
	exit 1
fi

echo "Updating staging db secrects"
(aws secretsmanager update-secret --profile=twitch-rbac-dev --region=us-west-2 --secret-id devsite/rbac/staging/db_rds --secret-string ${UPDATE_CREDS}) > /dev/null

SERVER_STATUS=$(aws elasticbeanstalk --profile=twitch-rbac-dev --region=us-west-2 describe-environment-health --environment-name staging-devsite-rbac-server --attribute-names All --query Status --output text)
if [ "${SERVER_STATUS}" != "Ready" ]
then
	echo "The staging elastic beanstalk cannot be restarted right now. "
	exit 1
fi

echo "Restarting staging app servers"
(aws elasticbeanstalk --profile=twitch-rbac-dev --region=us-west-2 restart-app-server --environment-name staging-devsite-rbac-server) > /dev/null

SERVER_STATUS="Updating"
while [ "${SERVER_STATUS}" != "Ready" ]
do
	echo "Waiting for app servers to finish restarting. Current Status is" ${SERVER_STATUS}
	sleep 60
	SERVER_STATUS=$(aws elasticbeanstalk --profile=twitch-rbac-dev --region=us-west-2 describe-environment-health --environment-name staging-devsite-rbac-server --attribute-names All --query Status --output text)
done

echo "The database swap has complete and staging is now using "$NEW_INSTANCE" as the new database intance"
