package s2s2

import (
	"code.justin.tv/amzn/TwitchS2S2/internal/authorization"
	"code.justin.tv/amzn/TwitchS2S2/internal/token"
)

// AuthorizedSubject is the interface that authenticated and authorized callers
// should implement.
type AuthorizedSubject interface {
	ID() string
	Scope() Scope
	TokenID() string
}

// Scope is the scope interface that AuthorizedSubject returns.
type Scope interface {
	IsSuperSetOf(scopes []string) bool
}

type authorizedSubject struct {
	authorization.Subject
	scope   token.Scope
	tokenID string
}

func (as *authorizedSubject) Scope() Scope {
	return as.scope
}

func (as *authorizedSubject) TokenID() string {
	return as.tokenID
}
