package logx

import (
	"context"
	"fmt"
)

type logger struct {
	ctx context.Context
}

func NewLoggerWrapper() *logger {
	return &logger{
		ctx: context.Background(),
	}
}

func (l *logger) Info(args ...interface{}) {
	Info(l.ctx, args)
}

func (l *logger) Infof(format string, args ...interface{}) {
	Info(l.ctx, fmt.Sprintf(format, args...))
}

func (l *logger) Infoln(args ...interface{}) {
	Info(l.ctx, args)
}

func (l *logger) Debug(args ...interface{}) {
	Info(l.ctx, args)
}

func (l *logger) Debugf(format string, args ...interface{}) {
	Info(l.ctx, fmt.Sprintf(format, args...))
}

func (l *logger) Debugln(args ...interface{}) {
	Info(l.ctx, args)
}

func (l *logger) Error(args ...interface{}) {
	Error(l.ctx, args)
}

func (l *logger) Errorf(format string, args ...interface{}) {
	Error(l.ctx, fmt.Sprintf(format, args...))
}

func (l *logger) Errorln(args ...interface{}) {
	Error(l.ctx, args)
}

func (l *logger) Fatal(args ...interface{}) {
	Fatal(l.ctx, args)
}

func (l *logger) Fatalf(format string, args ...interface{}) {
	Fatal(l.ctx, fmt.Sprintf(format, args...))
}

func (l *logger) Fatalln(args ...interface{}) {
	Fatal(l.ctx, args)
}

func (l *logger) Panic(args ...interface{}) {
	Fatal(l.ctx, args)
}

func (l *logger) Panicf(format string, args ...interface{}) {
	Fatal(l.ctx, fmt.Sprintf(format, args...))
}

func (l *logger) Panicln(args ...interface{}) {
	Fatal(l.ctx, args)
}

func (l *logger) Print(args ...interface{}) {
	Info(l.ctx, args)
}

func (l *logger) Printf(format string, args ...interface{}) {
	Info(l.ctx, fmt.Sprintf(format, args...))
}

func (l *logger) Println(args ...interface{}) {
	Info(l.ctx, args)
}

func (l *logger) Warn(args ...interface{}) {
	Warn(l.ctx, args)
}

func (l *logger) Warnf(format string, args ...interface{}) {
	Warn(l.ctx, fmt.Sprintf(format, args...))
}

func (l *logger) Warnln(args ...interface{}) {
	Warn(l.ctx, args)
}
