package main

import (
	"fmt"
	"os"

	"code.justin.tv/devrel/errxer/internal"
	"gopkg.in/urfave/cli.v1"
)

func main() {
	app := cli.NewApp()

	app.Name = "errxer"
	app.Usage = `Generate a wrapper interface to wrap errors with errx
Usage examples:
 * Local interface: "errxer InterfaceName",
 * External interface: "errxer website/org/repo/path.InterfaceName"
 * Tracking timings: "errxer --timings InterfaceName"`

	app.ArgsUsage = "interfaceName"
	app.Flags = []cli.Flag{
		&cli.BoolFlag{
			Name:  "timings",
			Usage: "Add field TimingFunc that can be set with a function to track method duration timings",
		},
	}

	app.Action = func(c *cli.Context) error {
		interfaceType := c.Args().Get(0)
		if interfaceType == "" {
			return cli.NewExitError("interfaceType is required", 1)
		}

		cwd, err := os.Getwd()
		if err != nil {
			return cli.NewExitError("unable to determine CWD: "+err.Error(), 1)
		}

		if err := internal.Run(internal.Config{
			Dir:         cwd,
			Name:        interfaceType,
			WithTimings: c.GlobalBool("timings"),
		}); err != nil {
			return cli.NewExitError("failed to run: "+err.Error(), 1)
		}

		fmt.Printf("Generated errxer wrapper for %q\n", interfaceType)

		return nil
	}

	app.Run(os.Args)
}
