package errors

import (
	"code.justin.tv/identity/passport/logger"
	i18n "code.justin.tv/web/go-i18n"
)

var (
	// FacebookUnexpected represents a general error raised during Facebook authentication.
	FacebookUnexpected = &WrappedError{
		InternalError: "unexpected error with facebook",
		ExternalMessage: i18n.T(
			"Oops! You authenticated via Facebook correctly, but we encountered an error. Please try again.",
			"Error text displayed when an unexpected error occurs when attempting to auth via facebook.",
		),
		Severity: defaultLogLevel,
		Code:     5001,
	}

	// FacebookAuth represents a general error when we can't authenticate with Facebook.
	FacebookAuth = &WrappedError{
		InternalError: "can't authenticate with facebook",
		ExternalMessage: i18n.T(
			"Oops! We've encountered an unexpected error authenticating you with Facebook. Please try again.",
			"Error text displayed when we run into an error when talking with Facebook.",
		),
		Severity: defaultLogLevel,
		Code:     5002,
	}

	// FacebookBadAuth represents an error raised when we are unable to verify the user identity with facebook.
	FacebookBadAuth = &WrappedError{
		InternalError: "unable to verify identity with facebook",
		ExternalMessage: i18n.T(
			"Oops! We were unable to verify your identity with Facebook. Please try again.",
			"Error text displayed when the user enters bad information when logging via Facebook",
		),
		Severity: logger.Warn,
		Code:     5003,
	}

	// FBUserNotFound represents a failure to return a user_id given a facebook_id.
	FBUserNotFound = &WrappedError{
		InternalError: "no twitch user connected to facebook user_id",
		ExternalMessage: i18n.T(
			"Oops! We were unable to verify your identity with Facebook. Please try again.",
			"Error text displayed when the user enters bad information when logging via Facebook",
		),
		Severity: defaultLogLevel,
		Code:     5004,
	}

	// FacebookConnectFailure represents an error raised when we are unable to add facebook_id to a user in rails.
	FacebookConnectFailure = &WrappedError{
		InternalError: "unable to connect twitch user to facebook user_id",
		ExternalMessage: i18n.T(
			"Oops! You authenticated via Facebook correctly, but we encountered an error. Please try again.",
			"Error text displayed when an unexpected error occurs when attempting to auth via facebook.",
		),
		Severity: logger.Warn,
		Code:     5005,
	}

	// FacebookUserExists represents a general error raised during Facebook authentication.
	FacebookUserExists = &WrappedError{
		InternalError: "facebook account already linked to a twitch user",
		ExternalMessage: i18n.T(
			"This facebook account is already linked to a user.",
			"Error text displayed when a user attempts to link a twitch account with facebook.",
		),
		Severity: defaultLogLevel,
		Code:     5006,
	}
)
