// Generated by https://github.com/gotnospirit/makeplural
// at Tue, 09 Jun 2015 18:02:38 +0200
//
// URL: https://github.com/unicode-cldr/cldr-core/raw/master/supplemental/ordinals.json
// $Revision: 11229 $
// $Date: 2015-02-18 09:11:57 -0600 (Wed, 18 Feb 2015) $
//
// URL: https://github.com/unicode-cldr/cldr-core/raw/master/supplemental/plurals.json
// $Revision: 11229 $
// $Date: 2015-02-18 09:11:57 -0600 (Wed, 18 Feb 2015) $

package plural

import (
	"fmt"
	"math"
	"strconv"
)

func mod(x, y float64) float64 {
	return math.Mod(x, y)
}

func float(v interface{}) float64 {
	switch v.(type) {
	case int:
		return float64(v.(int))

	case int64:
		return float64(v.(int64))

	case float64:
		return v.(float64)

	case string:
		floatval, err := strconv.ParseFloat(v.(string), 64)
		if nil != err {
			return 0.0
		}
		return floatval
	}
	return 0.0
}

var plural_funcs map[string]func(interface{}, bool) string

func init() {
	plural_funcs = make(map[string]func(interface{}, bool) string)

	plural_funcs["af"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ak"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["am"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["ar"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))
		n100 := mod(n, 100)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 0:
			return "zero"

		case n == 1:
			return "one"

		case n == 2:
			return "two"

		case n100 == 3, n100 == 4, n100 == 5, n100 == 6, n100 == 7, n100 == 8, n100 == 9, n100 == 10:
			return "few"

		case n100 == 11, n100 == 12, n100 == 13, n100 == 14, n100 == 15, n100 == 16, n100 == 17, n100 == 18, n100 == 19, n100 == 20, n100 == 21, n100 == 22, n100 == 23, n100 == 24, n100 == 25, n100 == 26, n100 == 27, n100 == 28, n100 == 29, n100 == 30, n100 == 31, n100 == 32, n100 == 33, n100 == 34, n100 == 35, n100 == 36, n100 == 37, n100 == 38, n100 == 39, n100 == 40, n100 == 41, n100 == 42, n100 == 43, n100 == 44, n100 == 45, n100 == 46, n100 == 47, n100 == 48, n100 == 49, n100 == 50, n100 == 51, n100 == 52, n100 == 53, n100 == 54, n100 == 55, n100 == 56, n100 == 57, n100 == 58, n100 == 59, n100 == 60, n100 == 61, n100 == 62, n100 == 63, n100 == 64, n100 == 65, n100 == 66, n100 == 67, n100 == 68, n100 == 69, n100 == 70, n100 == 71, n100 == 72, n100 == 73, n100 == 74, n100 == 75, n100 == 76, n100 == 77, n100 == 78, n100 == 79, n100 == 80, n100 == 81, n100 == 82, n100 == 83, n100 == 84, n100 == 85, n100 == 86, n100 == 87, n100 == 88, n100 == 89, n100 == 90, n100 == 91, n100 == 92, n100 == 93, n100 == 94, n100 == 95, n100 == 96, n100 == 97, n100 == 98, n100 == 99:
			return "many"
		}
	}

	plural_funcs["as"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1, n == 5, n == 7, n == 8, n == 9, n == 10:
				return "one"

			case n == 2, n == 3:
				return "two"

			case n == 4:
				return "few"

			case n == 6:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["asa"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ast"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["az"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)
		i10 := i % 10
		i100 := i % 100
		i1000 := i % 1000

		if ordinal {
			switch {
			default:
				return "other"

			case i10 == 1, i10 == 2, i10 == 5, i10 == 7, i10 == 8, i100 == 20, i100 == 50, i100 == 70, i100 == 80:
				return "one"

			case i10 == 3, i10 == 4, i1000 == 100, i1000 == 200, i1000 == 300, i1000 == 400, i1000 == 500, i1000 == 600, i1000 == 700, i1000 == 800, i1000 == 900:
				return "few"

			case i == 0, i10 == 6, i100 == 40, i100 == 60, i100 == 90:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["be"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))
		n10 := mod(n, 10)
		n100 := mod(n, 100)

		switch {
		default:
			return "other"

		case n10 == 1 && n100 != 11:
			return "one"

		case (n10 == 2 || n10 == 3 || n10 == 4) && n100 != 12 && n100 != 13 && n100 != 14:
			return "few"

		case n10 == 0, n10 == 5, n10 == 6, n10 == 7, n10 == 8, n10 == 9, n100 == 11, n100 == 12, n100 == 13, n100 == 14:
			return "many"
		}
	}

	plural_funcs["bem"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["bez"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["bg"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["bh"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["bm"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["bn"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1, n == 5, n == 7, n == 8, n == 9, n == 10:
				return "one"

			case n == 2, n == 3:
				return "two"

			case n == 4:
				return "few"

			case n == 6:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["bo"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["br"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))
		n10 := mod(n, 10)
		n100 := mod(n, 100)
		n1000000 := mod(n, 1000000)

		switch {
		default:
			return "other"

		case n10 == 1 && n100 != 11 && n100 != 71 && n100 != 91:
			return "one"

		case n10 == 2 && n100 != 12 && n100 != 72 && n100 != 92:
			return "two"

		case (n10 == 3 || n10 == 4 || n10 == 9) && n100 != 10 && n100 != 11 && n100 != 12 && n100 != 13 && n100 != 14 && n100 != 15 && n100 != 16 && n100 != 17 && n100 != 18 && n100 != 19 && n100 != 70 && n100 != 71 && n100 != 72 && n100 != 73 && n100 != 74 && n100 != 75 && n100 != 76 && n100 != 77 && n100 != 78 && n100 != 79 && n100 != 90 && n100 != 91 && n100 != 92 && n100 != 93 && n100 != 94 && n100 != 95 && n100 != 96 && n100 != 97 && n100 != 98 && n100 != 99:
			return "few"

		case n != 0 && n1000000 == 0:
			return "many"
		}
	}

	plural_funcs["brx"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["bs"] = func(value interface{}, ordinal bool) string {
		f, i, _, v, _, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100
		f10 := f % 10
		f100 := f % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case v == 0 && i10 == 1 && i100 != 11, f10 == 1 && f100 != 11:
			return "one"

		case v == 0 && (i10 == 2 || i10 == 3 || i10 == 4) && i100 != 12 && i100 != 13 && i100 != 14, (f10 == 2 || f10 == 3 || f10 == 4) && f100 != 12 && f100 != 13 && f100 != 14:
			return "few"
		}
	}

	plural_funcs["ca"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1, n == 3:
				return "one"

			case n == 2:
				return "two"

			case n == 4:
				return "few"
			}
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["ce"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["cgg"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["chr"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ckb"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["cs"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"

		case (i == 2 || i == 3 || i == 4) && v == 0:
			return "few"

		case v != 0:
			return "many"
		}
	}

	plural_funcs["cy"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			switch {
			default:
				return "other"

			case n == 0, n == 7, n == 8, n == 9:
				return "zero"

			case n == 1:
				return "one"

			case n == 2:
				return "two"

			case n == 3, n == 4:
				return "few"

			case n == 5, n == 6:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case n == 0:
			return "zero"

		case n == 1:
			return "one"

		case n == 2:
			return "two"

		case n == 3:
			return "few"

		case n == 6:
			return "many"
		}
	}

	plural_funcs["da"] = func(value interface{}, ordinal bool) string {
		_, i, n, _, t, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1, t != 0 && (i == 0 || i == 1):
			return "one"
		}
	}

	plural_funcs["de"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["dsb"] = func(value interface{}, ordinal bool) string {
		f, i, _, v, _, _ := finvtw(value)
		i100 := i % 100
		f100 := f % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case v == 0 && i100 == 1, f100 == 1:
			return "one"

		case v == 0 && i100 == 2, f100 == 2:
			return "two"

		case v == 0 && (i100 == 3 || i100 == 4), f100 == 3, f100 == 4:
			return "few"
		}
	}

	plural_funcs["dv"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["dz"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["ee"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["el"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["en"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)
		n10 := mod(n, 10)
		n100 := mod(n, 100)

		if ordinal {
			switch {
			default:
				return "other"

			case n10 == 1 && n100 != 11:
				return "one"

			case n10 == 2 && n100 != 12:
				return "two"

			case n10 == 3 && n100 != 13:
				return "few"
			}
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["eo"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["es"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["et"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["eu"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["fa"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["ff"] = func(value interface{}, ordinal bool) string {
		i := int64(float(value))

		switch {
		default:
			return "other"

		case i == 0, i == 1:
			return "one"
		}
	}

	plural_funcs["fi"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["fil"] = func(value interface{}, ordinal bool) string {
		f, i, n, v, _, _ := finvtw(value)
		i10 := i % 10
		f10 := f % 10

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case v == 0 && (i == 1 || i == 2 || i == 3), v == 0 && i10 != 4 && i10 != 6 && i10 != 9, v != 0 && f10 != 4 && f10 != 6 && f10 != 9:
			return "one"
		}
	}

	plural_funcs["fo"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["fr"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case i == 0, i == 1:
			return "one"
		}
	}

	plural_funcs["fur"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["fy"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["ga"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"

		case n == 3, n == 4, n == 5, n == 6:
			return "few"

		case n == 7, n == 8, n == 9, n == 10:
			return "many"
		}
	}

	plural_funcs["gd"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1, n == 11:
			return "one"

		case n == 2, n == 12:
			return "two"

		case n == 3, n == 4, n == 5, n == 6, n == 7, n == 8, n == 9, n == 10, n == 13, n == 14, n == 15, n == 16, n == 17, n == 18, n == 19:
			return "few"
		}
	}

	plural_funcs["gl"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["gsw"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["gu"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"

			case n == 2, n == 3:
				return "two"

			case n == 4:
				return "few"

			case n == 6:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["guw"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["gv"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100

		switch {
		default:
			return "other"

		case v == 0 && i10 == 1:
			return "one"

		case v == 0 && i10 == 2:
			return "two"

		case v == 0 && (i100 == 0 || i100 == 20 || i100 == 40 || i100 == 60 || i100 == 80):
			return "few"

		case v != 0:
			return "many"
		}
	}

	plural_funcs["ha"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["haw"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["he"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)
		n10 := mod(n, 10)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"

		case i == 2 && v == 0:
			return "two"

		case v == 0 && n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6 && n != 7 && n != 8 && n != 9 && n != 10 && n10 == 0:
			return "many"
		}
	}

	plural_funcs["hi"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"

			case n == 2, n == 3:
				return "two"

			case n == 4:
				return "few"

			case n == 6:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["hr"] = func(value interface{}, ordinal bool) string {
		f, i, _, v, _, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100
		f10 := f % 10
		f100 := f % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case v == 0 && i10 == 1 && i100 != 11, f10 == 1 && f100 != 11:
			return "one"

		case v == 0 && (i10 == 2 || i10 == 3 || i10 == 4) && i100 != 12 && i100 != 13 && i100 != 14, (f10 == 2 || f10 == 3 || f10 == 4) && f100 != 12 && f100 != 13 && f100 != 14:
			return "few"
		}
	}

	plural_funcs["hsb"] = func(value interface{}, ordinal bool) string {
		f, i, _, v, _, _ := finvtw(value)
		i100 := i % 100
		f100 := f % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case v == 0 && i100 == 1, f100 == 1:
			return "one"

		case v == 0 && i100 == 2, f100 == 2:
			return "two"

		case v == 0 && (i100 == 3 || i100 == 4), f100 == 3, f100 == 4:
			return "few"
		}
	}

	plural_funcs["hu"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1, n == 5:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["hy"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case i == 0, i == 1:
			return "one"
		}
	}

	plural_funcs["id"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["ig"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["ii"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["in"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["is"] = func(value interface{}, ordinal bool) string {
		_, i, _, _, t, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case t == 0 && i10 == 1 && i100 != 11, t != 0:
			return "one"
		}
	}

	plural_funcs["it"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 11, n == 8, n == 80, n == 800:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["iu"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["iw"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)
		n10 := mod(n, 10)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"

		case i == 2 && v == 0:
			return "two"

		case v == 0 && n != 0 && n != 1 && n != 2 && n != 3 && n != 4 && n != 5 && n != 6 && n != 7 && n != 8 && n != 9 && n != 10 && n10 == 0:
			return "many"
		}
	}

	plural_funcs["ja"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["jbo"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["jgo"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ji"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["jmc"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["jv"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["jw"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["ka"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)
		i100 := i % 100

		if ordinal {
			switch {
			default:
				return "other"

			case i == 1:
				return "one"

			case i == 0, i100 == 2, i100 == 3, i100 == 4, i100 == 5, i100 == 6, i100 == 7, i100 == 8, i100 == 9, i100 == 10, i100 == 11, i100 == 12, i100 == 13, i100 == 14, i100 == 15, i100 == 16, i100 == 17, i100 == 18, i100 == 19, i100 == 20, i100 == 40, i100 == 60, i100 == 80:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["kab"] = func(value interface{}, ordinal bool) string {
		i := int64(float(value))

		switch {
		default:
			return "other"

		case i == 0, i == 1:
			return "one"
		}
	}

	plural_funcs["kaj"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["kcg"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["kde"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["kea"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["kk"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))
		n10 := mod(n, 10)

		if ordinal {
			switch {
			default:
				return "other"

			case n10 == 6, n10 == 9, n10 == 0 && n != 0:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["kkj"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["kl"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["km"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["kn"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["ko"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["ks"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ksb"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ksh"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0:
			return "zero"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ku"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["kw"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["ky"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["lag"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		switch {
		default:
			return "other"

		case n == 0:
			return "zero"

		case (i == 0 || i == 1) && n != 0:
			return "one"
		}
	}

	plural_funcs["lb"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["lg"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["lkt"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["ln"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["lo"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		return "other"
	}

	plural_funcs["lt"] = func(value interface{}, ordinal bool) string {
		f, _, n, _, _, _ := finvtw(value)
		n10 := mod(n, 10)
		n100 := mod(n, 100)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n10 == 1 && n100 != 11 && n100 != 12 && n100 != 13 && n100 != 14 && n100 != 15 && n100 != 16 && n100 != 17 && n100 != 18 && n100 != 19:
			return "one"

		case (n10 == 2 || n10 == 3 || n10 == 4 || n10 == 5 || n10 == 6 || n10 == 7 || n10 == 8 || n10 == 9) && n100 != 11 && n100 != 12 && n100 != 13 && n100 != 14 && n100 != 15 && n100 != 16 && n100 != 17 && n100 != 18 && n100 != 19:
			return "few"

		case f != 0:
			return "many"
		}
	}

	plural_funcs["lv"] = func(value interface{}, ordinal bool) string {
		f, _, n, v, _, _ := finvtw(value)
		n10 := mod(n, 10)
		n100 := mod(n, 100)
		f100 := f % 100
		f10 := f % 10

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n10 == 0, n100 == 11, n100 == 12, n100 == 13, n100 == 14, n100 == 15, n100 == 16, n100 == 17, n100 == 18, n100 == 19, v == 2 && (f100 == 11 || f100 == 12 || f100 == 13 || f100 == 14 || f100 == 15 || f100 == 16 || f100 == 17 || f100 == 18 || f100 == 19):
			return "zero"

		case n10 == 1 && n100 != 11, v == 2 && f10 == 1 && f100 != 11, v != 2 && f10 == 1:
			return "one"
		}
	}

	plural_funcs["mas"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["mg"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["mgo"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["mk"] = func(value interface{}, ordinal bool) string {
		f, i, _, v, _, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100
		f10 := f % 10

		if ordinal {
			switch {
			default:
				return "other"

			case i10 == 1 && i100 != 11:
				return "one"

			case i10 == 2 && i100 != 12:
				return "two"

			case (i10 == 7 || i10 == 8) && i100 != 17 && i100 != 18:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case v == 0 && i10 == 1, f10 == 1:
			return "one"
		}
	}

	plural_funcs["ml"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["mn"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["mo"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)
		n100 := mod(n, 100)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"

		case v != 0, n == 0, n != 1 && (n100 == 1 || n100 == 2 || n100 == 3 || n100 == 4 || n100 == 5 || n100 == 6 || n100 == 7 || n100 == 8 || n100 == 9 || n100 == 10 || n100 == 11 || n100 == 12 || n100 == 13 || n100 == 14 || n100 == 15 || n100 == 16 || n100 == 17 || n100 == 18 || n100 == 19):
			return "few"
		}
	}

	plural_funcs["mr"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"

			case n == 2, n == 3:
				return "two"

			case n == 4:
				return "few"
			}
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["ms"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		return "other"
	}

	plural_funcs["mt"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))
		n100 := mod(n, 100)

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 0, n100 == 2, n100 == 3, n100 == 4, n100 == 5, n100 == 6, n100 == 7, n100 == 8, n100 == 9, n100 == 10:
			return "few"

		case n100 == 11, n100 == 12, n100 == 13, n100 == 14, n100 == 15, n100 == 16, n100 == 17, n100 == 18, n100 == 19:
			return "many"
		}
	}

	plural_funcs["my"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["nah"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["naq"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["nb"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["nd"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ne"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1, n == 2, n == 3, n == 4:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["nl"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["nn"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["nnh"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["no"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["nqo"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["nr"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["nso"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["ny"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["nyn"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["om"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["or"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["os"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["pa"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["pap"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["pl"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"

		case v == 0 && (i10 == 2 || i10 == 3 || i10 == 4) && i100 != 12 && i100 != 13 && i100 != 14:
			return "few"

		case v == 0 && i != 1 && (i10 == 0 || i10 == 1), v == 0 && (i10 == 5 || i10 == 6 || i10 == 7 || i10 == 8 || i10 == 9), v == 0 && (i100 == 12 || i100 == 13 || i100 == 14):
			return "many"
		}
	}

	plural_funcs["prg"] = func(value interface{}, ordinal bool) string {
		f, _, n, v, _, _ := finvtw(value)
		n10 := mod(n, 10)
		n100 := mod(n, 100)
		f100 := f % 100
		f10 := f % 10

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n10 == 0, n100 == 11, n100 == 12, n100 == 13, n100 == 14, n100 == 15, n100 == 16, n100 == 17, n100 == 18, n100 == 19, v == 2 && (f100 == 11 || f100 == 12 || f100 == 13 || f100 == 14 || f100 == 15 || f100 == 16 || f100 == 17 || f100 == 18 || f100 == 19):
			return "zero"

		case n10 == 1 && n100 != 11, v == 2 && f10 == 1 && f100 != 11, v != 2 && f10 == 1:
			return "one"
		}
	}

	plural_funcs["ps"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["pt"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case (n == 0 || n == 1 || n == 2) && n != 2:
			return "one"
		}
	}

	plural_funcs["pt-PT"] = func(value interface{}, ordinal bool) string {
		_, _, n, v, _, _ := finvtw(value)

		switch {
		default:
			return "other"

		case n == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["rm"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ro"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)
		n100 := mod(n, 100)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"

		case v != 0, n == 0, n != 1 && (n100 == 1 || n100 == 2 || n100 == 3 || n100 == 4 || n100 == 5 || n100 == 6 || n100 == 7 || n100 == 8 || n100 == 9 || n100 == 10 || n100 == 11 || n100 == 12 || n100 == 13 || n100 == 14 || n100 == 15 || n100 == 16 || n100 == 17 || n100 == 18 || n100 == 19):
			return "few"
		}
	}

	plural_funcs["rof"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["root"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["ru"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case v == 0 && i10 == 1 && i100 != 11:
			return "one"

		case v == 0 && (i10 == 2 || i10 == 3 || i10 == 4) && i100 != 12 && i100 != 13 && i100 != 14:
			return "few"

		case v == 0 && i10 == 0, v == 0 && (i10 == 5 || i10 == 6 || i10 == 7 || i10 == 8 || i10 == 9), v == 0 && (i100 == 11 || i100 == 12 || i100 == 13 || i100 == 14):
			return "many"
		}
	}

	plural_funcs["rwk"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["sah"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["saq"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["se"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["seh"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ses"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["sg"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["sh"] = func(value interface{}, ordinal bool) string {
		f, i, _, v, _, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100
		f10 := f % 10
		f100 := f % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case v == 0 && i10 == 1 && i100 != 11, f10 == 1 && f100 != 11:
			return "one"

		case v == 0 && (i10 == 2 || i10 == 3 || i10 == 4) && i100 != 12 && i100 != 13 && i100 != 14, (f10 == 2 || f10 == 3 || f10 == 4) && f100 != 12 && f100 != 13 && f100 != 14:
			return "few"
		}
	}

	plural_funcs["shi"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"

		case n == 2, n == 3, n == 4, n == 5, n == 6, n == 7, n == 8, n == 9, n == 10:
			return "few"
		}
	}

	plural_funcs["si"] = func(value interface{}, ordinal bool) string {
		f, i, n, _, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 0, n == 1, i == 0 && f == 1:
			return "one"
		}
	}

	plural_funcs["sk"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"

		case (i == 2 || i == 3 || i == 4) && v == 0:
			return "few"

		case v != 0:
			return "many"
		}
	}

	plural_funcs["sl"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)
		i100 := i % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case v == 0 && i100 == 1:
			return "one"

		case v == 0 && i100 == 2:
			return "two"

		case v == 0 && (i100 == 3 || i100 == 4), v != 0:
			return "few"
		}
	}

	plural_funcs["sma"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["smi"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["smj"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["smn"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["sms"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"

		case n == 2:
			return "two"
		}
	}

	plural_funcs["sn"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["so"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["sq"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))
		n10 := mod(n, 10)
		n100 := mod(n, 100)

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"

			case n10 == 4 && n100 != 14:
				return "many"
			}
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["sr"] = func(value interface{}, ordinal bool) string {
		f, i, _, v, _, _ := finvtw(value)
		i10 := i % 10
		i100 := i % 100
		f10 := f % 10
		f100 := f % 100

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case v == 0 && i10 == 1 && i100 != 11, f10 == 1 && f100 != 11:
			return "one"

		case v == 0 && (i10 == 2 || i10 == 3 || i10 == 4) && i100 != 12 && i100 != 13 && i100 != 14, (f10 == 2 || f10 == 3 || f10 == 4) && f100 != 12 && f100 != 13 && f100 != 14:
			return "few"
		}
	}

	plural_funcs["ss"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ssy"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["st"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["sv"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)
		n10 := mod(n, 10)
		n100 := mod(n, 100)

		if ordinal {
			switch {
			default:
				return "other"

			case (n10 == 1 || n10 == 2) && n100 != 11 && n100 != 12:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["sw"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["syr"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ta"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["te"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["teo"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["th"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["ti"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["tig"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["tk"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["tl"] = func(value interface{}, ordinal bool) string {
		f, i, n, v, _, _ := finvtw(value)
		i10 := i % 10
		f10 := f % 10

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		switch {
		default:
			return "other"

		case v == 0 && (i == 1 || i == 2 || i == 3), v == 0 && i10 != 4 && i10 != 6 && i10 != 9, v != 0 && f10 != 4 && f10 != 6 && f10 != 9:
			return "one"
		}
	}

	plural_funcs["tn"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["to"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["tr"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ts"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["tzm"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1, n == 11, n == 12, n == 13, n == 14, n == 15, n == 16, n == 17, n == 18, n == 19, n == 20, n == 21, n == 22, n == 23, n == 24, n == 25, n == 26, n == 27, n == 28, n == 29, n == 30, n == 31, n == 32, n == 33, n == 34, n == 35, n == 36, n == 37, n == 38, n == 39, n == 40, n == 41, n == 42, n == 43, n == 44, n == 45, n == 46, n == 47, n == 48, n == 49, n == 50, n == 51, n == 52, n == 53, n == 54, n == 55, n == 56, n == 57, n == 58, n == 59, n == 60, n == 61, n == 62, n == 63, n == 64, n == 65, n == 66, n == 67, n == 68, n == 69, n == 70, n == 71, n == 72, n == 73, n == 74, n == 75, n == 76, n == 77, n == 78, n == 79, n == 80, n == 81, n == 82, n == 83, n == 84, n == 85, n == 86, n == 87, n == 88, n == 89, n == 90, n == 91, n == 92, n == 93, n == 94, n == 95, n == 96, n == 97, n == 98, n == 99:
			return "one"
		}
	}

	plural_funcs["ug"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["uk"] = func(value interface{}, ordinal bool) string {
		_, i, n, v, _, _ := finvtw(value)
		n10 := mod(n, 10)
		n100 := mod(n, 100)
		i10 := i % 10
		i100 := i % 100

		if ordinal {
			switch {
			default:
				return "other"

			case n10 == 3 && n100 != 13:
				return "few"
			}
		}

		switch {
		default:
			return "other"

		case v == 0 && i10 == 1 && i100 != 11:
			return "one"

		case v == 0 && (i10 == 2 || i10 == 3 || i10 == 4) && i100 != 12 && i100 != 13 && i100 != 14:
			return "few"

		case v == 0 && i10 == 0, v == 0 && (i10 == 5 || i10 == 6 || i10 == 7 || i10 == 8 || i10 == 9), v == 0 && (i100 == 11 || i100 == 12 || i100 == 13 || i100 == 14):
			return "many"
		}
	}

	plural_funcs["ur"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["uz"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["ve"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["vi"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		if ordinal {
			switch {
			default:
				return "other"

			case n == 1:
				return "one"
			}
		}

		return "other"
	}

	plural_funcs["vo"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["vun"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["wa"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 0, n == 1:
			return "one"
		}
	}

	plural_funcs["wae"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["wo"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["xh"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["xog"] = func(value interface{}, ordinal bool) string {
		n := math.Abs(float(value))

		switch {
		default:
			return "other"

		case n == 1:
			return "one"
		}
	}

	plural_funcs["yi"] = func(value interface{}, ordinal bool) string {
		_, i, _, v, _, _ := finvtw(value)

		switch {
		default:
			return "other"

		case i == 1 && v == 0:
			return "one"
		}
	}

	plural_funcs["yo"] = func(value interface{}, ordinal bool) string {
		return "other"
	}

	plural_funcs["zh"] = func(value interface{}, ordinal bool) string {
		if ordinal {
			return "other"
		}

		return "other"
	}

	plural_funcs["zu"] = func(value interface{}, ordinal bool) string {
		flt := float(value)
		n := math.Abs(flt)
		i := int64(flt)

		if ordinal {
			return "other"
		}

		switch {
		default:
			return "other"

		case i == 0, n == 1:
			return "one"
		}
	}
}

func GetFunc(name string) (func(interface{}, bool) string, error) {
	fn, ok := plural_funcs[name]
	if !ok {
		return nil, fmt.Errorf("UnknownCulture: `%s`", name)
	}
	return fn, nil
}
