// tslint:disable-next-line: no-submodule-imports
import 'source-map-support/register';

import * as cdk from '@aws-cdk/core';

import { CertStack } from './cert-stack';
import { CommonStack } from './common-stack';
import { DiscussStack } from './discuss-stack';
import {
  PROD_ENV
} from './consts';
import { VpcStack } from './vpc-stack';

enum CreateStacksTarget {
  Prod
}

function createStacks(scope: cdk.App, env: cdk.Environment, target: CreateStacksTarget) {
  const prefix = CreateStacksTarget[target];

  // @ts-ignore -- Remove this after you are using these variables
  const vpcStack = new VpcStack(scope, prefix + 'Vpc', { env });
  // @ts-ignore -- Remove this after you are using these variables
  // const certStack = new CertStack(scope, prefix + 'Cert', { env });
  // @ts-ignore -- Remove this after you are using these variables
  const commonStack = new CommonStack(scope, prefix + 'Common', { env });

  const discussStack = new DiscussStack(scope, prefix + 'Discuss', {
  env,
  vpc: vpcStack.vpc,
  generalVpcESecurityGroup: vpcStack.generalVpcESecurityGroup,
  vpcStack,
  // DiscussCert: certStack.CERT,
});
discussStack.addDependency(commonStack);
}

const app = new cdk.App();
createStacks(app, PROD_ENV, CreateStacksTarget.Prod);
