import {
  Certificate,
  CertificateValidation,
  ValidationMethod
} from '@aws-cdk/aws-certificatemanager';
import { HostedZone } from '@aws-cdk/aws-route53';
import {
  Construct,
  Stack,
  StackProps
} from '@aws-cdk/core';

import {
  PROJECT_NAME,
  PROJECT_URL,
} from './consts';

// interface CertStackProps extends StackProps {}

export class CertStack extends Stack {
  public readonly CERT: Certificate;
  constructor(scope: Construct, name: string, props: StackProps) {
    super(scope, name, props);

    // const r53 = new HostedZone(this, "Z0344657UBOSRNINDW1Z", {zoneName: PROJECT_URL})
    const r53 = HostedZone.fromHostedZoneAttributes(this, 'MyZone', {
      zoneName: PROJECT_URL,
      hostedZoneId: 'Z0344657UBOSRNINDW1Z',
    });

    this.CERT = new Certificate(this, PROJECT_NAME, {
      domainName: PROJECT_URL,
      validationMethod: ValidationMethod.DNS,
      validation: CertificateValidation.fromDns(r53)
    });
  }
}
