import {SecurityGroup,
  IVpc,
  Vpc,
  Peer,
  Port  
} from '@aws-cdk/aws-ec2';
import {
  Construct,
  Stack,
  StackProps
} from '@aws-cdk/core';
import { PROD_ACCOUNT_ID, PROD_VPC_ID } from './consts';

export class VpcStack extends Stack {
  public readonly vpc: IVpc;
  public readonly generalVpcESecurityGroup: SecurityGroup;

  constructor(scope: Construct, name: string, props: StackProps) {
    super(scope, name, props);
    
    this.vpc = Vpc.fromLookup(this, 'Vpc', {
      vpcId: PROD_VPC_ID,
    });    
    
    this.generalVpcESecurityGroup = new SecurityGroup(this, 'DiscussSG', {
      vpc: this.vpc,
      allowAllOutbound: true,
      description: 'Allows ports 80 (http), 443 (https), and 25 (SMTP) inbound. Outbound is unchanged.',
    });
    this.generalVpcESecurityGroup.addIngressRule(Peer.anyIpv4(), Port.tcp(25));
    this.generalVpcESecurityGroup.addIngressRule(Peer.anyIpv4(), Port.tcp(22));
    this.generalVpcESecurityGroup.addIngressRule(Peer.anyIpv4(), Port.tcp(80));
    this.generalVpcESecurityGroup.addIngressRule(Peer.anyIpv4(), Port.tcp(443));
    this.generalVpcESecurityGroup.addIngressRule(this.generalVpcESecurityGroup, Port.tcp(5432)); // postgresql
  }
}
