import * as cdk from '@aws-cdk/core';
import * as ecr from '@aws-cdk/aws-ecr';
import { Config } from './config';

export class FilesServiceDataStack extends cdk.Stack {
  repo: ecr.Repository;

  constructor(scope: cdk.Construct, config: Config) {
    super(scope, config.prefix + 'FilesServiceData', { env: config.env });

    this.repo = new ecr.Repository(this, 'Repo');
  }
}
