import * as route53 from '@aws-cdk/aws-route53';
import * as elasticbeanstalk from '@aws-cdk/aws-elasticbeanstalk';

/**
 * Use an ElasticBeanstalk Environment as an alias record target
 */
export class ElasticBeanstalkTarget implements route53.IAliasRecordTarget {
  /**
   * The hosted zone Id if using an alias record in Route53.
   * This value never changes for each region.
   */
  public static readonly ELB_US_EAST_1_ZONE_ID = 'Z35SXDOTRQ7X7K';

  constructor(private readonly environment: elasticbeanstalk.CfnEnvironment) {}

  public bind(_record: route53.IRecordSet): route53.AliasRecordTargetConfig {
    return {
      hostedZoneId: ElasticBeanstalkTarget.ELB_US_EAST_1_ZONE_ID,
      dnsName: `dualstack.${this.environment.attrEndpointUrl}`,
    };
  }
}
