import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';
import { Config } from './config';

/**
 * Defines the VPC and VPC endpoints.
 */
export class VpcStack extends cdk.Stack {
  readonly vpc: ec2.Vpc;

  constructor(scope: cdk.Construct, config: Config) {
    super(scope, config.prefix + 'Vpc', { env: config.env });

    this.vpc = new ec2.Vpc(this, 'Vpc', {
      maxAzs: 3,
    });

    // AWS service VPC endpoints
    this.vpc.addDynamoDbEndpoint('DynamoDBEndpoint');
    this.vpc.addS3Endpoint('S3GatewayEndpoint');
    // this.vpc.addInterfaceEndpoint('CloudWatchEndpoint', {
    //   service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH,
    // });
    // this.vpc.addInterfaceEndpoint('SQSEndpoint', {
    //   service: ec2.InterfaceVpcEndpointAwsService.SQS,
    // });
  }
}
