package main

import (
	"log"
	"os"

	grafana "code.justin.tv/live/autohost-grafana"
)

func main() {
	args := os.Args
	if len(args) != 2 {
		log.Fatalf(`Usage:
    ./generate-nexus-dashboard OUT_FILE_PATH
`)
	}
	outputFilePath := args[1]

	err := Run(outputFilePath)
	if err != nil {
		log.Fatalln(err)
	}
}

func Run(outputFilePath string) error {
	categoryDBGetCategoryIDFrmName := grafana.Dependency{
		Name:        "CategoryDB:GetGameFromName",
		CircuitName: "CategoryDBClient_GetCategoryIDFromName",
	}
	categoryDBGetGameListFromIds := grafana.Dependency{
		Name: "CategoryDB:GetGameListFromIds",
	}
	dynamoDBGetItem := grafana.Dependency{
		Name: "dynamodb:GetItem",
	}
	dynamoDBPutItem := grafana.Dependency{
		Name: "dynamodb:PutItem",
	}
	hallpassGetV1PermissionsChannelsEditors := grafana.Dependency{
		Name:        "Hallpass:GetV1PermissionsChannelsEditors",
		CircuitName: "HallpassClient_IsChannelEditor",
	}
	hostingAddToAutohostList := grafana.Dependency{
		Name:        "hosting/Hosting:AddToAutohostList",
		CircuitName: "AutohostClient_AddToAutohostList",
	}
	hostingGetAutohostChannelForCarousel := grafana.Dependency{
		Name:        "hosting/Hosting:GetAutohostChannelForCarousel",
		CircuitName: "AutohostClient_GetAutohostChannelForCarousel",
	}
	hostingGetAutohostList := grafana.Dependency{
		Name:        "hosting/Hosting:GetAutohostList",
		CircuitName: "AutohostClient_GetAutohostList",
	}
	hostingGetAutohostSettings := grafana.Dependency{
		Name:        "hosting/Hosting:GetAutohostSettings",
		CircuitName: "AutohostClient_GetAutohostSettings",
	}
	hostingGetEndorsedChannels := grafana.Dependency{
		Name:        "hosting/Hosting:GetEndorsedChannels",
		CircuitName: "AutohostClient_GetEndorsedChannels",
	}
	hostingRemoveFromAutohostList := grafana.Dependency{
		Name:        "hosting/Hosting:RemoveFromAutohostList",
		CircuitName: "AutohostClient_RemoveFromAutohostList",
	}
	hostingSetAutohostList := grafana.Dependency{
		Name:        "hosting/Hosting:SetAutohostList",
		CircuitName: "AutohostClient_SetAutohostList",
	}
	hostingUpdateAutohostSettings := grafana.Dependency{
		Name:        "hosting/Hosting:UpdateAutohostSettings",
		CircuitName: "AutohostClient_UpdateAutohostSettings",
	}
	livelineGetStreamsByChannelIDs := grafana.Dependency{
		Name:        "Liveline:GetStreamsByChannelIDs",
		CircuitName: "LivelineClient_GetStreamsByChannelIDs",
	}
	momentumBatchGetChapters := grafana.Dependency{
		Name:        "momentum/Momentum:BatchGetChapters",
		CircuitName: "MomentumClient_BatchGetChapters",
	}
	momentumApiGetChapters := grafana.Dependency{
		Name:        "momentumapi/Momentumapi:GetChapters",
		CircuitName: "MomentumapiClient_GetChapters",
	}
	pokedexGetVodsByChannels := grafana.Dependency{
		Name:        "Pokedex:GetVodsByChannels",
		CircuitName: "PokedexClient_GetVodsByChannels",
	}
	redisDel := grafana.Dependency{
		Name: "redis:del",
	}
	redisGet := grafana.Dependency{
		Name: "redis:get",
	}
	redisSet := grafana.Dependency{
		Name: "redis:set",
	}
	rosterGetChannelsMemberships := grafana.Dependency{
		Name: "Roster:GetChannelsMemberships",
	}
	rosterGetTeamsMemberships := grafana.Dependency{
		Name: "Roster:GetTeamsMemberships",
	}
	zumaModerate := grafana.Dependency{
		Name:        "Zuma:Moderate",
		CircuitName: "ZumaClient_Moderate",
	}

	dependencies := []grafana.Dependency{
		categoryDBGetCategoryIDFrmName,
		categoryDBGetGameListFromIds,
		dynamoDBGetItem,
		dynamoDBPutItem,
		hallpassGetV1PermissionsChannelsEditors,
		hostingAddToAutohostList,
		hostingGetAutohostChannelForCarousel,
		hostingGetAutohostList,
		hostingGetAutohostSettings,
		hostingGetEndorsedChannels,
		hostingRemoveFromAutohostList,
		hostingSetAutohostList,
		hostingUpdateAutohostSettings,
		livelineGetStreamsByChannelIDs,
		momentumApiGetChapters,
		momentumBatchGetChapters,
		pokedexGetVodsByChannels,
		redisDel,
		redisGet,
		redisSet,
		rosterGetChannelsMemberships,
		rosterGetTeamsMemberships,
		zumaModerate,
	}
	operations := []grafana.Operation{
		{
			Name: "AddToAutohostList",
			Dependencies: []grafana.Dependency{
				hostingAddToAutohostList,
			},
		},
		{
			Name: "CreateChannelSocialMedia",
			Dependencies: []grafana.Dependency{
				dynamoDBGetItem,
				dynamoDBPutItem,
				redisDel,
				zumaModerate,
			},
		},
		{
			Name: "CreateChannelSocialMedia",
			Dependencies: []grafana.Dependency{
				dynamoDBGetItem,
				dynamoDBPutItem,
				redisDel,
				zumaModerate,
			},
		},
		{
			Name: "DeleteChannelSocialMedia",
			Dependencies: []grafana.Dependency{
				dynamoDBGetItem,
				dynamoDBPutItem,
				redisDel,
			},
		},
		{
			Name: "EventbusChannelEndorsementListUpdate",
			Dependencies: []grafana.Dependency{
				redisDel,
				redisGet,
			},
		},
		{
			Name: "EventbusStreamDelete",
			Dependencies: []grafana.Dependency{
				redisDel,
			},
		},
		{
			Name: "GetAutohostChannels",
			Dependencies: []grafana.Dependency{
				hostingGetEndorsedChannels,
			},
		},
		{
			Name: "GetAutohostChannelForCarousel",
			Dependencies: []grafana.Dependency{
				hostingGetAutohostChannelForCarousel,
			},
		},
		{
			Name: "GetAutohostList",
			Dependencies: []grafana.Dependency{
				hostingGetAutohostList,
			},
		},
		{
			Name: "GetAutohostSettings",
			Dependencies: []grafana.Dependency{
				hostingGetAutohostSettings,
			},
		},
		{
			Name: "GetCategoryShelf",
			Dependencies: []grafana.Dependency{
				categoryDBGetCategoryIDFrmName,
				dynamoDBGetItem,
				momentumApiGetChapters,
				momentumBatchGetChapters,
				pokedexGetVodsByChannels,
				redisGet,
				redisSet,
			},
		},
		{
			Name: "GetPreferences",
			Dependencies: []grafana.Dependency{
				dynamoDBGetItem,
				redisGet,
				redisSet,
			},
		},
		{
			Name: "GetRecentlyStreamedCategories",
			Dependencies: []grafana.Dependency{
				categoryDBGetCategoryIDFrmName,
				dynamoDBGetItem,
				hallpassGetV1PermissionsChannelsEditors,
				momentumApiGetChapters,
				pokedexGetVodsByChannels,
				redisGet,
				redisSet,
			},
		},
		{
			Name: "GetStreamerShelf",
			Dependencies: []grafana.Dependency{
				dynamoDBGetItem,
				hostingGetAutohostList,
				livelineGetStreamsByChannelIDs,
				rosterGetChannelsMemberships,
				rosterGetTeamsMemberships,
				redisGet,
				redisSet,
			},
		},
		{
			Name: "RemoveFromAutohostList",
			Dependencies: []grafana.Dependency{
				hostingRemoveFromAutohostList,
			},
		},
		{
			Name: "SetAutohostList",
			Dependencies: []grafana.Dependency{
				hostingSetAutohostList,
			},
		},
		{
			Name: "UpdateAutohostSettings",
			Dependencies: []grafana.Dependency{
				hostingUpdateAutohostSettings,
			},
		},
		{
			Name: "UpdateChannelSocialMedia",
			Dependencies: []grafana.Dependency{
				dynamoDBGetItem,
				dynamoDBPutItem,
				redisDel,
				zumaModerate,
			},
		},
		{
			Name: "UpdatePreferences",
			Dependencies: []grafana.Dependency{
				categoryDBGetGameListFromIds,
				hallpassGetV1PermissionsChannelsEditors,
				dynamoDBGetItem,
				dynamoDBPutItem,
				redisDel,
			},
		},
	}

	builder := grafana.NewDashboardBuilder(&grafana.DashboardBuilderArgs{
		Namespace:       "TwitchNexus",
		Service:         "TwitchNexus",
		DashboardID:     1731,
		DashboardTitle:  "TwitchNexus - API",
		DashboardUID:    "73fsCODMz",
		DataSourceRegex: "/^nexus/",
		Stages:          []string{"prod", "beta"},
		SubStages:       []string{"primary", "canary"},
	})
	builder.AddTitlePanel("Overview")
	builder.AddRow("Errors Overview", false)
	builder.AddErrorSummaryPanels(operations, "Twirp APIs")

	latencyOverviewRowID := builder.AddRow("Latency Overview", true)
	builder.AddLatencySummaryPanels(operations, latencyOverviewRowID, "Twirp APIs")

	throughputOverviewRowID := builder.AddRow("Throughput Overview", true)
	builder.AddThroughputSummaryPanels(operations, throughputOverviewRowID, "Twirp APIs")

	builder.AddDependencyDetailPanels(dependencies)
	builder.AddDetailPanels(operations, "API Details")

	return builder.ToFile(outputFilePath)
}
